/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import java.io.Serializable;
import pt.caf_pbs.schooldiskapi.dto.SubjectDTO;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;

public class Subject
implements Serializable {
    private String initials;
    private String designation;

    public Subject(String initials, String designation) {
        this.setInitials(initials);
        this.designation = designation;
    }

    public Subject(Subject obj) {
        this.setInitials(obj.initials);
        this.designation = obj.designation;
    }

    public Subject(SubjectDTO obj) {
        this.setInitials(obj.getInitials());
        this.designation = obj.getDesignation();
    }

    private boolean isInitialsValid(String initials) {
        return initials.length() >= 4;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        if (!this.isInitialsValid(initials)) {
            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
        this.initials = initials;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public boolean isEqualTo(Subject obj) {
        return this.initials.equals(obj.initials);
    }

    public boolean isEqualTo(String str) {
        return this.initials.equals(str);
    }
}

